﻿using Microsoft.WindowsAzure.Storage.Table;

namespace VA.PPMS.IWS.TableService.Interface.Entities
{
    public class NpiStatusEntity : TableEntity
    {
        public string Npi { get; set; }

        public string NpiType { get; set; }

        public string Status { get; set; }

        public string Key
        {
            get
            {
                if (Npi.Length > 1)
                    return Npi.Substring(0, 2);
                else
                    return "0";
            }
        }

        public NpiStatusEntity() { }

        public NpiStatusEntity(string npi, string npiType, string status)
        {
            // validate NPI value
            int npiValue;
            if (!int.TryParse(npi, out npiValue))
            {
                throw new System.ArgumentException("NPI value is invalid.");
            }

            Npi = npi;
            NpiType = npiType;
            Status = status;

            this.PartitionKey = Key;
            this.RowKey = npi;
        }

    }
}